<h3 class="mb-3 fw-bold">Rekapitulasi Nilai</h3>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        
        <!-- Tombol Tambah -->
        <div class="mb-3">
            <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#mNilai">
                <i class="bi bi-plus-lg me-1"></i> Input Nilai
            </button>
        </div>

        <!-- Tabel Data -->
        <table id="tabelNilai" class="table table-bordered table-hover w-100 table-data">
            <thead class="table-light">
                <tr>
                    <th>Siswa</th>
                    <th>Mapel</th>
                    <th>UH</th>
                    <th>UTS</th>
                    <th>UAS</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $q = mysqli_query($koneksi, "SELECT nilai.*, siswa.nama FROM nilai JOIN siswa ON nilai.id_siswa = siswa.id"); 
                while($d = mysqli_fetch_array($q)){ 
                ?>
                <tr>
                    <td><?php echo $d['nama']; ?></td>
                    <td><?php echo $d['mapel']; ?></td>
                    <td><?php echo $d['nilai_uh']; ?></td>
                    <td><?php echo $d['nilai_uts']; ?></td>
                    <td><?php echo $d['nilai_uas']; ?></td>
                    <td class="text-center">
                        <a href="proses/act_nilai.php?aksi=hapus_nilai&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Hapus nilai ini?')">X</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Input Nilai -->
<div class="modal fade" id="mNilai">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- PENTING: Action mengarah ke file proses -->
            <form method="POST" action="proses/act_nilai.php">
                <div class="modal-header">
                    <h5 class="modal-title">Input Nilai Siswa</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label>Pilih Siswa</label>
                        <select name="id_siswa" class="form-select" required>
                            <option value="">-- Pilih --</option>
                            <?php 
                            $s = mysqli_query($koneksi, "SELECT * FROM siswa ORDER BY nama ASC"); 
                            while($r = mysqli_fetch_array($s)){ 
                                echo "<option value='$r[id]'>$r[nama] - $r[kelas]</option>"; 
                            } 
                            ?>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label>Mata Pelajaran</label>
                        <input type="text" name="mapel" class="form-control" placeholder="Contoh: Matematika" required>
                    </div>
                    <div class="row">
                        <div class="col">
                            <label>Nilai UH</label>
                            <input type="number" name="uh" class="form-control" placeholder="0-100">
                        </div>
                        <div class="col">
                            <label>Nilai UTS</label>
                            <input type="number" name="uts" class="form-control" placeholder="0-100">
                        </div>
                        <div class="col">
                            <label>Nilai UAS</label>
                            <input type="number" name="uas" class="form-control" placeholder="0-100">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_nilai" class="btn btn-primary">Simpan Data</button>
                </div>
            </form>
        </div>
    </div>
</div>